<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    $datiGeecomAdmin = $geecomDb->leggiSingolaRiga("geec_prodotti","Admin","nome");
    $datiGeecomCms   = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    $cartellaAmministrazione = str_replace("../","",$datiGeecomCms["percorso"]);
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <title>Installazione del componente ecommerce</title>
        <?php
            include "../{$datiGeecomCms["percorso"]}/include/cssBaseAreaAmministrativa.php";
        ?>
	  
    </head>
    <body class="bg-primary">
        <main role="main" class="d-flex align-items-center mt-0">
            <div id="installazione" class="container">
                <div class="row">
                    <div class="col-sm-8 col-md-6 mx-auto">
                        <div class="card box-shadow-lite mb-4">
                            <div class="row">
                                <div class="col-8 col-lg-6 mx-auto">
                                    <img class="img-fluid logo mb-4" src="../template/img/geecom.svg" />
                                </div>
                                <div class="col-12">
                                    <p>Installazione del componente e-commerce di Geecom</p>                                        
                                    <?php
                                        if($datiGeecomAdmin["installato"]!="si") {
                                            echo"<p class=\"alert alert-warning\"><strong>Il componente ecommerce richiede Geecom Admin per funzionare.</strong> Installalo e ricarica questa pagina</p>";
                                        }
                                        else {
                                    ?>
                                        <form name="formInstallazione" action="install.php" method="post">
                                            <div class="alert alert-info">
                                                <strong>Attenzione!</strong> Un ecommerce non è un semplice sito internet, è un'attività imprenditoriale soggetta alle 
                                                leggi dello stato in cui viene registrato. Geecom e il suo componente e-commerce sono strumenti che 
                                                consentono di vendere online, richiedono conoscenza del prodotto e delle normative.

                                                <div class="form-check mt-2">
                                                    <input class="form-check-input" type="checkbox" id="condizioniEcommerce">
                                                    <label class="form-check-label">Ho letto e accetto le condizioni</label>
                                                </div>
                                            </div>
                                            
                                            
                                            <button type="button" onclick="controlloForm()" class="btn btn-primary btn-block">Installa</button>
                                        </form>
                                    <?php
                                        }
                                    ?>
                                </div>
                            </div>

                        </div><!-- /card-container -->
                    </div>
                </div>
            </div><!-- /container -->
        </main>

        <footer class="footer">
          <div class="container text-center"><?php echo $infoGeecom["versione"]; ?></div>
        </footer>
	  
	<?php 
            include "../{$datiGeecomCms["percorso"]}/include/jsBaseAreaAmministrativa.php";
        ?>
        
        <!-- Password strength meter -->
	<script type="text/javascript" src="../plugins/password-strength-meter-1.1.0/dist/password.min.js"></script>
	<script type="text/javascript">
            jQuery(document).ready(function($) {
                $('#password').password({
                  shortPass: '<span class="pwd-corta">La password è troppo corta, usa una password <strong>FORTE</strong> per scongiurare attacchi al tuo sito</span>',
                  badPass: '<span class="pwd-insufficiente">Insufficiente. Prova a combinare lettere e numeri</span>',
                  goodPass: '<span class="pwd-media">Media, aggiungi un carattere speciale per renderla più sicura</span>',
                  strongPass: '<span class="pwd-forte">Password forte</span>',
                  containsUsername: '<span class="pwd-corta">La tua password contiene lo username! Per motivi di sicurezza è bene sia diversa</span>',
                  enterPass: '',
                  showPercent: false,
                  animate: false,
                  minimumLength: 6,
                });
            });
        </script>
    
        <script>
            
            function controlloForm() {
                var checkbox = document.getElementById("condizioniEcommerce");
                if(checkbox.checked) {
                    document.formInstallazione.submit();
                }
                else {
                    alert("Devi accettare i termini e condizioni per installare il componente");
                }
            }
        </script>
    </body>
</html>
